---
id: 0b5eb1d4-6e8c-4625-8336-116edc5f8297
type:
  - document
title: Example Markdown File
slug: doc-test-example
metadata:
  css_class: custom-theme
  file_path: test-example.md
  file_type: md
  frontmatter:
    tags:
      - example
      - test
      - demo
    title: Example Markdown File
    author: John Doe
    excerpt: This is a test markdown file to demonstrate the system
    version: 1.0.0
    category: tutorial
    copyable: true
    cssClass: custom-theme
    published: true
    difficulty: beginner
    syntaxTheme: dark
    lastReviewed: 2025-01-17
    relatedTopics:
      - markdown
      - frontmatter
      - documentation
    showLineNumbers: true
    estimatedReadTime: 5
created: 2025-10-18T00:44:17.233+00:00
updated: 2026-03-01T00:07:02.64244+00:00
---

# Example Markdown File

This is a test markdown file to demonstrate the markdown library system.

## Features Demonstrated

- **Frontmatter**: YAML metadata at the top
- **Code blocks**: With syntax highlighting
- **Copy functionality**: Each code block can be copied
- **Tags**: For categorization and filtering

## Code Example

Here's a simple JavaScript function:

```javascript
function greetUser(name) {
  console.log(`Hello, ${name}!`);
  return `Welcome, ${name}`;
}

// Usage
const message = greetUser("World");
```

## Python Example

```python
def fibonacci(n):
    if n <= 1:
        return n
    return fibonacci(n-1) + fibonacci(n-2)

# Generate first 10 numbers
for i in range(10):
    print(f"F({i}) = {fibonacci(i)}")
```

## SQL Query

```sql
SELECT 
  id,
  title,
  tags,
  created_at
FROM markdown_files 
WHERE tags @> ARRAY['example']
ORDER BY created_at DESC;
```

## Conclusion

This system provides:

1. **File Management**: Create, edit, delete markdown files
2. **Search & Filter**: Find files by content, tags, or title
3. **Copy Functionality**: Easy copying of code snippets
4. **Folder Organization**: Organize files in folders
5. **Database Indexing**: Fast search with PostgreSQL full-text search

The frontmatter controls how the content is rendered and displayed.

